//----------------------------------------------------------------------------
//  Project dynresp
//  University of Manheim, Germany
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    dynresp.apx Application
//  FILE:         dyndialg.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TDynDialog (TDialog).
//
//----------------------------------------------------------------------------
#include <owl/pch.h>

#include "dyndialg.h"


//
// Build a response table for all messages/commands handled by the application.
//
DEFINE_RESPONSE_TABLE1(TDynDialog, TDialog)
//{{TDynDialogRSP_TBL_BEGIN}}
  EV_BN_CLICKED(IDC_BUTTON1, BNClicked),
//{{TDynDialogRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TDynDialog Implementation}}


TDynDialog::TDynDialog(TWindow* parent, TResId resId, TModule* module)
:
    TDialog(parent, resId, module)
{
}


TDynDialog::~TDynDialog()
{
  Destroy(IDCANCEL);
// delete[] pButtons;
 
}


void TDynDialog::BNClicked()
{
  // INSERT>> Your code here.
  pButtons[0] = new TButton (this,IDBASE,"Button 1",20,50,80,20);
  pButtons[0]->Create();
  pButtons[1] = new TButton (this,IDBASE+1,"Button 2",20,80,80,20);
  pButtons[1]->Create();
  pButtons[2] = new TButton (this,IDBASE+2,"Button 3",20,110,80,20);
  pButtons[2]->Create();
}


TResult TDynDialog::EvCommand(uint id, THandle hWndCtl, uint notifyCode)

//Responds to the messages sent by the dynamically created controls

{
  TResult result;
  result = TDialog::EvCommand(id, hWndCtl, notifyCode);

  if (notifyCode == BN_CLICKED)
   if (id >= IDBASE)
    if (id < IDBASE + NUMCTRL)
    {
     char szString[255];
     sprintf (szString,"You've pressed Button %i",id-IDBASE);
     MessageBox (szString,"DynControl");
    }//if
  return result;
}

