//----------------------------------------------------------------------------
//  Project DynResp
//  University of Manheim, Germany
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    DynResp Application
//  FILE:         dynrspad.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TDynRespAboutDlg (TDialog).
//
//----------------------------------------------------------------------------
#if !defined(dynrspad_h)              // Sentry, use file only if it's not already included.
#define dynrspad_h

#include <owl/static.h>

#include "dynrspap.rh"                  // Definition of all resources.


//{{TDialog = TDynRespAboutDlg}}
class TDynRespAboutDlg : public TDialog {
  public:
    TDynRespAboutDlg(TWindow* parent, TResId resId = IDD_ABOUT, TModule* module = 0);
    virtual ~TDynRespAboutDlg();

//{{TDynRespAboutDlgVIRTUAL_BEGIN}}
  public:
    void SetupWindow();
//{{TDynRespAboutDlgVIRTUAL_END}}
};    //{{TDynRespAboutDlg}}


// Reading the VERSIONINFO resource.
//
class TProjectRCVersion {
  public:
    TProjectRCVersion(TModule* module);
    virtual ~TProjectRCVersion();

    bool GetProductName(LPSTR& prodName);
    bool GetProductVersion(LPSTR& prodVersion);
    bool GetCopyright(LPSTR& copyright);
    bool GetDebug(LPSTR& debug);

  protected:
    uint8 far*  TransBlock;
    void far*   FVData;

  private:
    // Don't allow this object to be copied.
    //
    TProjectRCVersion(const TProjectRCVersion&);
    TProjectRCVersion& operator = (const TProjectRCVersion&);
};


#endif  // dynrspad_h sentry.
