//----------------------------------------------------------------------------
//  Project DynResp
//  University of Manheim, Germany
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    DynResp Application
//  FILE:         dynrspap.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TDynRespApp (TApplication).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include <stdio.h>

#include "dynrspap.h"
#include "dynrspwn.h"                        // Definition of client class.
#include "dynrspad.h"                        // Definition of about dialog.


//{{TDynRespApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TDynRespApp, TApplication)
//{{TDynRespAppRSP_TBL_BEGIN}}
  EV_COMMAND(CM_FILENEW, CmFileNew),
  EV_COMMAND(CM_FILEOPEN, CmFileOpen),
  EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{TDynRespAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//--------------------------------------------------------
// TDynRespApp
//
TDynRespApp::TDynRespApp() : TApplication("DynResp")
{

  // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
  // computed in the member functions CmFileOpen, and CmFileSaveAs.
  //
  FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  FileData.SetFilter("Alle Dateien (*.*)|*.*|All Files (*.*)|*.*|");
  FileData.DefExt = "txt";

  // INSERT>> Your constructor code here.
}


TDynRespApp::~TDynRespApp()
{
  // INSERT>> Your destructor code here.
}


//--------------------------------------------------------
// TDynRespApp
// ~~~~~
// Application intialization.
//
void TDynRespApp::InitMainWindow()
{
  if (nCmdShow != SW_HIDE)
    nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

  TSDIDecFrame* frame = new TSDIDecFrame(0, GetName(), 0, false);

  // Assign icons for this application.
  //
  frame->SetIcon(this, IDI_SDIAPPLICATION);
  frame->SetIconSm(this, IDI_SDIAPPLICATION);

  // Menu associated with window and accelerator table associated with table.
  //
  frame->AssignMenu(IDM_SDI);

  // Associate with the accelerator table.
  //
  frame->Attr.AccelTable = IDM_SDI;

  SetMainWindow(frame);

  frame->SetMenuDescr(TMenuDescr(IDM_SDI));
}



//--------------------------------------------------------
// TDynRespApp
// ~~~~~~~~~~~
// Menu File New command
//
void TDynRespApp::CmFileNew()
{
}


//--------------------------------------------------------
// TDynRespApp
// ~~~~~~~~~~~
// Menu File Open command
//
void TDynRespApp::CmFileOpen()
{
  // Display standard Open dialog box to select a file name.
  //
  *FileData.FileName = 0;

  TDynRespWindow* client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), TDynRespWindow);     // Client window for the frame.
  if (client->CanClose())
    if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
      OpenFile();
}


void TDynRespApp::OpenFile(const char* fileName)
{
  if (fileName)
    strcpy(FileData.FileName, fileName);

}


//{{TSDIDecFrame Implementation}}


TSDIDecFrame::TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection, TModule* module)
:
  TDecoratedFrame(parent, title, !clientWnd ? new TDynRespWindow(0, "") : clientWnd, trackMenuSelection, module)
{
  // INSERT>> Your constructor code here.

}


TSDIDecFrame::~TSDIDecFrame()
{
  // INSERT>> Your destructor code here.

}


//--------------------------------------------------------
// TDynRespApp
// ~~~~~~~~~~~
// Menu Help About DynResp command
//
void TDynRespApp::CmHelpAbout()
{
  // Show the modal dialog.
  //
  TDynRespAboutDlg(MainWindow).Execute();
}



int OwlMain(int , char* [])
{
  TDynRespApp   app;
  return app.Run();
}
