//----------------------------------------------------------------------------
//  Project DynResp
//  University of Manheim, Germany
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    DynResp Application
//  FILE:         dynrspap.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TDynRespApp (TApplication).
//
//----------------------------------------------------------------------------
#if !defined(dynrspap_h)              // Sentry, use file only if it's not already included.
#define dynrspap_h

#include <owl/opensave.h>


#include "dynrspap.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = TSDIDecFrame}}
class TSDIDecFrame : public TDecoratedFrame {
  public:
    TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection = false, TModule* module = 0);
    ~TSDIDecFrame();
};    //{{TSDIDecFrame}}


//{{TApplication = TDynRespApp}}
class TDynRespApp : public TApplication {
  private:


  public:
    TDynRespApp();
    virtual ~TDynRespApp();

    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
    void OpenFile(const char* fileName = 0);

//{{TDynRespAppVIRTUAL_BEGIN}}
  public:
    virtual void InitMainWindow();
//{{TDynRespAppVIRTUAL_END}}

//{{TDynRespAppRSP_TBL_BEGIN}}
  protected:
    void CmFileNew();
    void CmFileOpen();
    void CmHelpAbout();
//{{TDynRespAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TDynRespApp);
};    //{{TDynRespApp}}


#endif  // dynrspap_h sentry.
