//----------------------------------------------------------------------------
//  Project DynResp
//  University of Manheim, Germany
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    DynResp Application
//  FILE:         dynrspwn.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TDynRespWindow (TWindow).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include "dynrspap.h"

#include "dynrspwn.h"

#include <stdio.h>


//
// Build a response table for all messages/commands handled by the application.
//
DEFINE_RESPONSE_TABLE1(TDynRespWindow, TWindow)
//{{TDynRespWindowRSP_TBL_BEGIN}}
  EV_COMMAND(CM_DYNDIALOG, CmDyndialog),
  EV_COMMAND(CM_DYNITEM, CmDynitem),
//{{TDynRespWindowRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TDynRespWindow Implementation}}


//--------------------------------------------------------
// TDynRespWindow
// ~~~~~~~~~~
// Construction/Destruction handling.
//
TDynRespWindow::TDynRespWindow(TWindow* parent, const char far* title, TModule* module)
:
  TWindow(parent, title, module)
{
  // INSERT>> Your constructor code here.

}


TDynRespWindow::~TDynRespWindow()
{
  Destroy();

  // INSERT>> Your destructor code here.

}

void TDynRespWindow::CmDyndialog()
{
  // INSERT>> Your code here.
 TDynDialog Dialog (this);
 Dialog.Execute();
}


void TDynRespWindow::CmDynitem()
{
 //get the main menu
 HWND HFrame = *GetApplication()->GetMainWindow();
 TMenu *pMenu = new TMenu (HFrame);

 // get the submenu where the new items will be inserted
 TMenu* pSubMenu = new TMenu(pMenu->GetSubMenu(1));

 // insert two new item at the end
 pSubMenu->InsertMenu(3, MF_BYPOSITION, IDITEMBASE,"Menuitem 1");
 pSubMenu->InsertMenu(4, MF_BYPOSITION, IDITEMBASE+1,"Menuitem 2");

 delete pMenu;
 delete pSubMenu;

}

TResult TDynRespWindow::EvCommand(uint id, THandle hWndCtl, uint notifyCode)

/* Handles command notificatios send by the menuitems with no response table
   entry defined */

{
  TResult result;
  result = TWindow::EvCommand(id, hWndCtl, notifyCode);

  if (notifyCode == WM_NULL)
   if (id == IDITEMBASE)
    MessageBox ("You' ve selected Menuitem 1","Dynamic Menuitems");
   else
    if (id == IDITEMBASE+1)
     MessageBox ("You' ve selected Menuitem 2","Dynamic Menuitems");
  return result;
}

void TDynRespWindow::EvCommandEnable(TCommandEnabler& Enabler)
{
  if (IDITEMBASE <= Enabler.Id && Enabler.Id <= IDITEMBASE+NUMITEMS)
  {
    // enable dynamic menu specific item
    Enabler.Enable(true);
  }//if
  else
    TWindow::EvCommandEnable(Enabler);
}


