//----------------------------------------------------------------------------
//  Project DynResp
//  University of Manheim, Germany
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    DynResp Application
//  FILE:         dynrspwn.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TDynRespWindow (TWindow).
//
//----------------------------------------------------------------------------
#if !defined(dynrspwn_h)              // Sentry, use file only if it's not already included.
#define dynrspwn_h

#include "dynrspap.rh"            // Definition of all resources.
#include "dyndialg.h"

#define NUMITEMS 2
#define IDITEMBASE 31000

//{{TWindow = TDynRespWindow}}
class TDynRespWindow : public TWindow {
  public:
    TDynRespWindow(TWindow* parent, const char far* title = 0, TModule* module = 0);
    virtual ~TDynRespWindow();
    
    TResult EvCommand       (uint id, THandle hWndCtl, uint notifyCode);
     void   EvCommandEnable (TCommandEnabler& Enabler);

//{{TDynRespWindowRSP_TBL_BEGIN}}
  protected:
    void CmDyndialog();
    void CmDynitem();
//{{TDynRespWindowRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TDynRespWindow);
};    //{{TDynRespWindow}}


#endif  // dynrspwn_h sentry.
