/*
 * multisel.cpp
 *
 * Shows how to play with multiselection open dialog boxes using OWL framework
 * Copyright (C) 1997 Brice VIDAL
 *
 * Just more mumbo-jumbo...
 *
 * This program is free software; you can redistribute it and/or
 * modify it.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

//------------------------------------------------------------------------------
// using a larger FileName
//------------------------------------------------------------------------------

#include <owl/opensave.h>

TOpenSaveDialog::TData FileData(OFN_EXPLORER | OFN_ALLOWMULTISELECT,
			(char*)"Your App Files (*.app)|*.app| RTF Files (*.rtf)|*.rtf| Text Files (*.txt)|*.txt| All Files (*.*)|*.*|",
         (char*)"*.app",
         (char*)"C:\\BC5",
         (char*)"app",
         500,
         0);
         TData(uint32 flags=0, char* filter=0, char* customFilter=0,
              char* initialDir=0, char* defExt=0,int maxPath=0, 
              int filterIndex = 0);

//------------------------------------------------------------------------------
// normal utilisation with a space delimiter
//------------------------------------------------------------------------------

#include <owl/mdi.h>
#include <owl/opensave.h>

#include <cstring.h>

class TYourMDIClient:public TMDIClient
{
//...
	private:
   	TOpenSaveDialog::TData FileData;
      void TYourMDIClient::OpenFile(const char* fileName = 0)
//...
};

void TYourMDIClient::SetupWindow()
{
  // Default SetUpWindow processing.
  //
  TMDIClient::SetupWindow();

  // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
  // computed in the member functions CmFileOpen, and CmFileSaveAs.
  //
  FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ALLOWMULTISELECT;
  // Here wez set all the flags:
  //	OFN_FILEMUSTEXIST:     the file won't be created if it does not exists
  //  OFN_HIDEREADONLY:      hides the read only check box
  //  OFN_ALLOWMULTISELECT:  allows multiselection
  //  OFN_EXPLORER:          gives an explorer aspect = normal win95 dialogs with a combo box displaying the directory
  // For more flags see your help file in the TopenSaveDialog :: TData structure :: flags help file

  FileData.SetFilter("Your App Files (*.app)|*.app| RTF Files (*.rtf)|*.rtf| Text Files (*.txt)|*.txt| All Files (*.*)|*.*|");
  // Set the names that appears in the combo box then the exrension

  FileData.DefExt = "app";

  // Do what ever you want
// ...
}

void TYourMDIClient::OpenFile(const char* fileName)     // Opens the file
{
	if(!fileName)
   	// look in FileData.FileName for the file to open

   // Do what ever you want
// ...
}

void TYourMDIClient::CmFileOpen()       // responds to your Command Open file
{
  // Display standard Open dialog box to select a file name.
  //
  *(FileData.FileName) = 0;        // resets the FileName

  if (TFileOpenDialog(this, FileData).Execute() == IDOK)
  {
    	char *p;

    /* strtok places a NULL terminator
    in front of the token = get the path */
    	p = strtok(FileData.FileName, ' ');
    	string path(p);


    /* A second call to strtok using a NULL
    as the first parameter returns a pointer
    to the character following the token = the file name */
    	while(p = strtok(NULL, ' '))
	 	{
      	string openName(p);
         openName = path + openName;
         OpenFile(openName.c_str());
      }
  }
}

//------------------------------------------------------------------------------
// advanced utilisation: cutomize as needed
//------------------------------------------------------------------------------

#include <owl/opensave.h>

class TYourOpenSaveDialog : private TOpenSaveDialog
{
	public:
	// constructor
   // destructor

   protected:
   void Init(TResId templateId);

   private:
   // copy constructor if needed
   // operator = if needed
};

class TYourFileOpenDialog : public TYourOpenSaveDialog
{
	public:
   // constructor
   int  DoExecute();

   private:
   // copy constructor
   // operator =
};

class TYourFileSaveDialog : public TYourOpenSaveDialog
{
	public:
   // constructor
   int  DoExecute();

   private:
   // copy constructor
   // operator =
};

void TYourOpenSaveDialog::Init(TResId templateId)
{
	// call the nor mal init
   TOpenSaveDialog::Init(templateId);

   // do what ever you want
}

int TYourFileOpenDialog::DoExecute()
{
	// have a look at opensave.h
}

int TYourFileSaveDialog::DoExecute()
{
	// have a look at opensave.h
}
