#include <owl\applicat.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
//#include <owl\edit.h>
#include <owl\radiobut.h>
#include <owl\groupbox.h>
#include "sb_test.rh"
//#include <stdio.h>
#include "staticbm.h"

// -------------------------------------------------------------

class PictureDialog:public TDialog {
	 public:
				PictureDialog();
	 protected:
		void	SetupWindow();
		void	BitmapChanged(UINT);
		TBitmap	*Bitmap;
		TPalette	*Palette;
		TRadioButton *p1,*p2,*p3;
		StaticBitmap *bitmap1,*bitmap2,*bitmap3,*bitmap4;
	 private:
		void	SetBitmap();
		int	CurrentView;
		DECLARE_RESPONSE_TABLE(PictureDialog);
};

DEFINE_RESPONSE_TABLE1(PictureDialog,TDialog)
  EV_CHILD_NOTIFY_ALL_CODES(IDC_GROUPBOX1,BitmapChanged),
END_RESPONSE_TABLE;

PictureDialog::PictureDialog(): TDialog(0,DIALOG_1) {
	 TGroupBox* group = new TGroupBox(this,IDC_GROUPBOX1);
	 p1 = new TRadioButton(this,IDC_RADIOBUTTON1,group);
	 p2 = new TRadioButton(this,IDC_RADIOBUTTON2,group);
	 p3 = new TRadioButton(this,IDC_RADIOBUTTON3,group);
	 TDib *dib=new TDib("test.bmp");
	 Palette=new TPalette(*dib);
	 Bitmap=new TBitmap(*dib);
//	 Palette=NULL;
	 bitmap1=new StaticBitmap(this,Bitmap,Palette,IDC_BITMAP1,0,0,100,65);	// plain
	 bitmap2=new StaticBitmap(this,Bitmap,Palette,IDC_BITMAP2,0,0,100,65,false,true);	// use aspect ratio
	 bitmap3=new StaticBitmap(this,Bitmap,Palette,IDC_BITMAP3,0,0,100,65,false,false,true);	// masked
	 bitmap4=new StaticBitmap(this,Bitmap,Palette,IDC_BITMAP4,0,0,100,65,false,true,true);	// masked aspect ratio
	 CurrentView=0;
	 delete dib;
}

void PictureDialog::SetupWindow() {
	TDialog::SetupWindow();
	p1->Check();
}

// -------------------------------------------------------------

void PictureDialog::BitmapChanged(UINT) {
	if (p1->GetState() && BF_CHECKED)
		CurrentView=0;
	else
		if (p2->GetState() && BF_CHECKED)
			CurrentView=1;
		else
			CurrentView=2;
	SetBitmap();
}

void PictureDialog::SetBitmap() {
	switch (CurrentView) {
		case 0:
			bitmap1->UpdateBitmap(Bitmap,0,0,100,65,false);
			bitmap2->UpdateBitmap(Bitmap,0,0,100,65,false);
			bitmap3->UpdateBitmap(Bitmap,0,0,100,65,true);
			bitmap4->UpdateBitmap(Bitmap,0,0,100,65,true);
		break;

		case 1:
			bitmap1->UpdateBitmap(Bitmap,25,8,50,32,false);
			bitmap2->UpdateBitmap(Bitmap,25,8,50,32,false);
			bitmap3->UpdateBitmap(Bitmap,25,8,50,32,true);
			bitmap4->UpdateBitmap(Bitmap,25,8,50,32,true);
		break;

		case 2:
			bitmap1->UpdateBitmap(Bitmap,10,20,80,25,false);
			bitmap2->UpdateBitmap(Bitmap,10,20,80,25,false);
			bitmap3->UpdateBitmap(Bitmap,10,20,80,25,true);
			bitmap4->UpdateBitmap(Bitmap,10,20,80,25,true);
		break;
	}
}

class PictureApp: public TApplication {
	public:
		void InitMainWindow() {
			TDialog* picture = new PictureDialog();
			MainWindow = new TFrameWindow(0,"PictureDialog",picture,true);
			MainWindow->Attr.Style &= ~WS_THICKFRAME & ~WS_MAXIMIZEBOX;
			EnableCtl3d();
		}
};

int OwlMain(int,char*[]) {
	 PictureApp pictureApp;
	 return pictureApp.Run();
}

/* -------------------------------------------------------------
			End of sb_test.cpp : Static Bitmap test program
	------------------------------------------------------------- */