/* -------------------------------------------------------------
									staticbm.h
	An OWL static bitmap class for dialogs
	Allows highlighting (by drawing a border), aspect resizing,
	and masking (i.e. transparency)
	-------------------------------------------------------------
	Written by Richard Brown
	Richard@TowerSoftware.com
	------------------------------------------------------------- */

#ifndef _STATICBM_H
#define _STATICBM_H
#include <owl\static.h>
#include <owl\gdiobjec.h>
#include <owl\dc.h>

// -------------------------------------------------------------

class StaticBitmap: public TStatic {
	 public:
					StaticBitmap(TWindow* parent,TBitmap *user_bitmap,TPalette *user_palette,int id,
						int x,int y,int width,int height,bool flag=false,bool useaspect=false,bool use_mask=true);
					~StaticBitmap();
		void		SetText(char * text);
		void		UpdateBitmap(TBitmap *user_bitmap,int x,int y,int width,int height,bool use_mask=true);
		bool		IsOver(TPoint& point);
		void		Select(bool flag);
	 protected:
		void		SetupWindow();
		void		Paint(TDC& dc,bool,TRect&);
	 private:
		enum		{ BORDER_OFFSET=2 };
		TBitmap	*Bitmap,*MaskBitmap;
		TPalette	*Palette;
		int		X,Y,Width,Height;
		bool		Selected,prevSelected,UseAspect,MaskUsed;
};
#endif

/* -------------------------------------------------------------
							End of staticbm.h
	------------------------------------------------------------- */
