//----------------------------------------------------------------------------
//  Project Tooltip
//  Uni Mannheim
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    Tooltip Application
//  FILE:         tltpabtd.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TTooltipAboutDlg (TDialog).
//
//----------------------------------------------------------------------------
#if !defined(tltpabtd_h)              // Sentry, use file only if it's not already included.
#define tltpabtd_h

#include <owl/static.h>

#include "toltpapp.rh"                  // Definition of all resources.


//{{TDialog = TTooltipAboutDlg}}
class TTooltipAboutDlg : public TDialog {
  public:
    TTooltipAboutDlg(TWindow* parent, TResId resId = IDD_ABOUT, TModule* module = 0);
    virtual ~TTooltipAboutDlg();

//{{TTooltipAboutDlgVIRTUAL_BEGIN}}
  public:
    void SetupWindow();
//{{TTooltipAboutDlgVIRTUAL_END}}
};    //{{TTooltipAboutDlg}}


// Reading the VERSIONINFO resource.
//
class TProjectRCVersion {
  public:
    TProjectRCVersion(TModule* module);
    virtual ~TProjectRCVersion();

    bool GetProductName(LPSTR& prodName);
    bool GetProductVersion(LPSTR& prodVersion);
    bool GetCopyright(LPSTR& copyright);
    bool GetDebug(LPSTR& debug);

  protected:
    uint8 far*  TransBlock;
    void far*   FVData;

  private:
    // Don't allow this object to be copied.
    //
    TProjectRCVersion(const TProjectRCVersion&);
    TProjectRCVersion& operator = (const TProjectRCVersion&);
};


#endif  // tltpabtd_h sentry.
