//----------------------------------------------------------------------------
//  Project Tooltip
//  Uni Mannheim
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    Tooltip Application
//  FILE:         tltpwndw.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TTooltipWindow (TWindow).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include "toltpapp.h"

#include "tltpwndw.h"

#include <stdio.h>


//
// Build a response table for all messages/commands handled by the application.
//
DEFINE_RESPONSE_TABLE1(TTooltipWindow, TWindow)
//{{TTooltipWindowRSP_TBL_BEGIN}}
  EV_COMMAND(CM_TOOLTIP, CmTooltip),
  EV_COMMAND(CM_DLGBASE, CmDlgbase),
//{{TTooltipWindowRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TTooltipWindow Implementation}}


//--------------------------------------------------------
// TTooltipWindow
// ~~~~~~~~~~
// Construction/Destruction handling.
//
TTooltipWindow::TTooltipWindow(TWindow* parent, const char far* title, TModule* module)
:
  TWindow(parent, title, module)
{
  // INSERT>> Your constructor code here.

}


TTooltipWindow::~TTooltipWindow()
{
  Destroy();

  // INSERT>> Your destructor code here.

}

void TTooltipWindow::CmTooltip()
{
  // INSERT>> Your code here.
 TTooltipDialog   Dialog (this);
 Dialog.Execute();
}


void TTooltipWindow::CmDlgbase()
{
  // INSERT>> Your code here.
 TDialogBase   Dialog (this,IDD_TOOLTIPDIALOG);
 Dialog.Execute();
}

