//----------------------------------------------------------------------------
//  Project Tooltip
//  Uni Mannheim
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    Tooltip Application
//  FILE:         toltpapp.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TTooltipApp (TApplication).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include <stdio.h>

#include "toltpapp.h"
#include "tltpwndw.h"                        // Definition of client class.
#include "tltpabtd.h"                        // Definition of about dialog.


//{{TTooltipApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TTooltipApp, TApplication)
//{{TTooltipAppRSP_TBL_BEGIN}}
  EV_COMMAND(CM_FILENEW, CmFileNew),
  EV_COMMAND(CM_FILEOPEN, CmFileOpen),
//{{TTooltipAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//--------------------------------------------------------
// TTooltipApp
//
TTooltipApp::TTooltipApp() : TApplication("Tooltip")
{

  // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
  // computed in the member functions CmFileOpen, and CmFileSaveAs.
  //
  FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  FileData.SetFilter("Alle Dateien (*.*)|*.*|All Files (*.*)|*.*|");
  FileData.DefExt = "txt";

  // INSERT>> Your constructor code here.
}


TTooltipApp::~TTooltipApp()
{
  // INSERT>> Your destructor code here.
}


//--------------------------------------------------------
// TTooltipApp
// ~~~~~
// Application intialization.
//
void TTooltipApp::InitMainWindow()
{
  if (nCmdShow != SW_HIDE)
    nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

  TSDIDecFrame* frame = new TSDIDecFrame(0, GetName(), 0, false);

  // Assign icons for this application.
  //
  frame->SetIcon(this, IDI_SDIAPPLICATION);
  frame->SetIconSm(this, IDI_SDIAPPLICATION);

  // Menu associated with window and accelerator table associated with table.
  //
  frame->AssignMenu(IDM_SDI);

  // Associate with the accelerator table.
  //
  frame->Attr.AccelTable = IDM_SDI;

  SetMainWindow(frame);

  frame->SetMenuDescr(TMenuDescr(IDM_SDI));
}



//--------------------------------------------------------
// TTooltipApp
// ~~~~~~~~~~~
// Menu File New command
//
void TTooltipApp::CmFileNew()
{
}


//--------------------------------------------------------
// TTooltipApp
// ~~~~~~~~~~~
// Menu File Open command
//
void TTooltipApp::CmFileOpen()
{
  // Display standard Open dialog box to select a file name.
  //
  *FileData.FileName = 0;

  TTooltipWindow* client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), TTooltipWindow);     // Client window for the frame.
  if (client->CanClose())
    if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
      OpenFile();
}


void TTooltipApp::OpenFile(const char* fileName)
{
  if (fileName)
    strcpy(FileData.FileName, fileName);

}


//{{TSDIDecFrame Implementation}}


TSDIDecFrame::TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection, TModule* module)
:
  TDecoratedFrame(parent, title, !clientWnd ? new TTooltipWindow(0, "") : clientWnd, trackMenuSelection, module)
{
  // INSERT>> Your constructor code here.

}


TSDIDecFrame::~TSDIDecFrame()
{
  // INSERT>> Your destructor code here.

}


//--------------------------------------------------------
// TTooltipApp
// ~~~~~~~~~~~
// Menu Help About Tooltip command
//
void TTooltipApp::CmHelpAbout()
{
  // Show the modal dialog.
  //
  TTooltipAboutDlg(MainWindow).Execute();
}



int OwlMain(int , char* [])
{
  TTooltipApp   app;
  return app.Run();
}
