//----------------------------------------------------------------------------
//  Project Tooltip
//  Uni Mannheim
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    Tooltip Application
//  FILE:         toltpapp.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TTooltipApp (TApplication).
//
//----------------------------------------------------------------------------
#if !defined(toltpapp_h)              // Sentry, use file only if it's not already included.
#define toltpapp_h

#include <owl/opensave.h>


#include "toltpapp.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = TSDIDecFrame}}
class TSDIDecFrame : public TDecoratedFrame {
  public:
    TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection = false, TModule* module = 0);
    ~TSDIDecFrame();
};    //{{TSDIDecFrame}}


//{{TApplication = TTooltipApp}}
class TTooltipApp : public TApplication {
  private:


  public:
    TTooltipApp();
    virtual ~TTooltipApp();

    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
    void OpenFile(const char* fileName = 0);

//{{TTooltipAppVIRTUAL_BEGIN}}
  public:
    virtual void InitMainWindow();
//{{TTooltipAppVIRTUAL_END}}

//{{TTooltipAppRSP_TBL_BEGIN}}
  protected:
    void CmFileNew();
    void CmFileOpen();
    void CmHelpAbout();
//{{TTooltipAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TTooltipApp);
};    //{{TTooltipApp}}


#endif  // toltpapp_h sentry.
