//----------------------------------------------------------------------------
//  Project tooltip
//  Uni Mannheim
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    tooltip.apx Application
//  FILE:         toltpdlg.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TTooltipDialog (TDialogBase).
//
//----------------------------------------------------------------------------
#include <owl/pch.h>

#include "toltpdlg.h"




TTooltipDialog::TTooltipDialog(TWindow* parent, TResId resId, TModule* module)
:
    TDialogBase(parent, resId, module)
{
  // INSERT>> Your constructor code here.
  pOk = new TButton (this,IDOK);
  pCancel = new TButton (this,IDCANCEL);
  pHelp = new TButton (this,IDHELP);
}


TTooltipDialog::~TTooltipDialog()
{
  Destroy(IDCANCEL);

  // INSERT>> Your destructor code here.

}

void TTooltipDialog::SetupWindow ()

{
 TDialogBase::SetupWindow();
 
 TToolInfo Ok (*this,pOk->HWindow,"OK Button");
 GetToolTip()->AddTool (Ok);
 TToolInfo Cancel (*this,pCancel->HWindow,"Cancel Button");
 GetToolTip()->AddTool (Cancel);
 TToolInfo Help (*this,pHelp->HWindow,"Help Button");
 GetToolTip()->AddTool (Help);
}
