//----------------------------------------------------------------------------
//  Project metais
//
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    Application
//  FILE:         dialogbase.cpp
//  AUTHOR:       Mark Caroli, University of Mannheim
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TDialogBase (TDialog).
//
//----------------------------------------------------------------------------

#include "dialogbase.h"


TDialogBase::TDialogBase(TWindow* parent, TResId resId, TModule* module)
:
    TDialog(parent, resId, module)
{
 //Tooltip erzeugen
 pToolTip = NULL;
 pToolTip = new TTooltip(this);
}


TDialogBase::~TDialogBase()
{
  if (pToolTip)
   delete pToolTip;
}

void TDialogBase::SetupWindow()

{
  TDialog::SetupWindow();
  AddTools();
  pToolTip->Activate();
}

//*** acc key handling *****
bool TDialogBase::Create()

{
 IsModalDialog = false;
 return TDialog::Create();
}

int TDialogBase::Execute()

{
 IsModalDialog = true;
 if (TDialog::Create())
  return GetApplication()->BeginModal (this,MB_TASKMODAL);
 else
  return -1;
}

void TDialogBase::Destroy (int ret)

{
 if (IsModalDialog)
 {
  GetApplication()->EndModal(IDCANCEL);
  IsModalDialog = false;
 }
 TDialog::Destroy(ret);
}


bool TDialogBase::PreProcessMsg (MSG &msg)

{
 if (pToolTip)
  if (pToolTip->IsWindow())
   pToolTip->RelayEvent (msg);
 return TDialog::PreProcessMsg(msg);
}



