//----------------------------------------------------------------------------
//  Project metais
//
//  Copyright  1996. Alle Rechte vorbehalten.
//
//  SUBSYSTEM:    metais.apx Application
//  FILE:         sicht.h
//  AUTHOR:
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TDialogBase (TDialog).
//
//----------------------------------------------------------------------------
#if !defined(dialogbase_h)              // Sentry, use file only if it's not already included.
#define dialogbase_h

#include <owl/dialog.h>
#include <owl/tooltip.h>


class TDialogBase : public TDialog

//Diaolg classs that enables
//- catching accelerators
//- tooltips
//in dialogs.
//This is achieved by simulating a modal dialog by an modeless dialog

{
 public:
  TDialogBase(TWindow* parent, TResId resId, TModule* module = 0);
  virtual ~TDialogBase();

  virtual void SetupWindow();
  virtual void Destroy (int);
  virtual bool Create ();
  virtual int  Execute ();
  virtual bool PreProcessMsg (MSG& msg);
  TTooltip*    GetToolTip ()
                {return pToolTip;};
 protected:
  virtual void AddTools () {};                
 private:
  bool         IsModalDialog; //for acc. catching
  TTooltip     *pToolTip;
};

#endif

