//
// minsvc.cpp
// ~~~~~~~~~~
// Demonstrates a minimal service using the TService class.
//
// To register:   minsvc /register
// To unregister: minsvc /unregister
// To debug:      minsvc /debug
// To start:      net start MinimalService
// To stop:       net stop MinimalService
// To pause:      net pause MinimalService
// To continue:   net continue MinimalService
//

#include <owl/pch.h>
#include <string.h>
#include "service.h"


class TMinimalService : public TService
{
  public:
    const char* GetName() const { return "MinimalService"; }
    const char* GetDisplayName() const { return "Minimal Service"; }
    void Run();
};


void TMinimalService::Run()
{
  while (!CheckStop())
    Sleep(500);
}


int main(int argc, char* argv[])
{
  TMinimalService service;

  if (argc > 1 && stricmp(argv[1], "/register") == 0)
    service.Register();
  else if (argc > 1 && stricmp(argv[1], "/unregister") == 0)
    service.Unregister();
  else if (argc > 1 && stricmp(argv[1], "/debug") == 0)
    service.Start(argc, argv);
  else
    service.Start();

  return 0;
}