/*
 * multisel.cpp
 *
 * Shows how to play with gauges using OWL framework
 * Copyright (C) 1997 Brice VIDAL
 *
 * Just more mumbo-jumbo...
 *
 * This program is free software; you can redistribute it and/or
 * modify it.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <owl/pch.h>

#include <owl/gauge.h>
#include <owl/color.h>

#define IDC_GAUGEH1	101
#define IDC_GAUGEH2	102
#define IDC_GAUGEH3	103
#define IDC_GAUGEV1	104
#define IDC_GAUGEV2	105
#define IDC_GAUGEV3	106

#define IDT_GAUGEH1  107
#define IDT_GAUGEH2  108
#define IDT_GAUGEH3  109
#define IDT_GAUGEV1  110
#define IDT_GAUGEV2  111
#define IDT_GAUGEV3  112

class TGaugeWindow : public TWindow
{
  public:
    TGaugeWindow();
    virtual ~TGaugeWindow();

    void SetupWindow();

  private:
  	 TGauge* gaugeh1;
    TGauge* gaugeh2;
    TGauge* gaugeh3;
    TGauge* gaugev1;
    TGauge* gaugev2;
    TGauge* gaugev3;

    void EvTimer(uint timerId);

DECLARE_RESPONSE_TABLE(TGaugeWindow);
};

class TGaugeApp : public TApplication
{
  public:
    TGaugeApp();
    virtual ~TGaugeApp();

  public:
    virtual void InitMainWindow();
};



//{{TGaugeApp Implementation}}


//--------------------------------------------------------
// TGaugeApp
//
TGaugeApp::TGaugeApp() : TApplication("Gauges")
{}


TGaugeApp::~TGaugeApp()
{}


//--------------------------------------------------------
// TGaugeApp
// ~~~~~
// Application intialization.
//
void TGaugeApp::InitMainWindow()
{
  TFrameWindow* frame = new TFrameWindow(0, "Gauge Display",
                                             new TGaugeWindow, true);
  frame->EnableKBHandler();
  frame->Attr.Style &= ~(WS_THICKFRAME|WS_MAXIMIZEBOX);

  SetMainWindow(frame);
}

//--------------------------------------------------------
// TGaugeWindow

DEFINE_RESPONSE_TABLE1(TGaugeWindow, TWindow)
	EV_WM_TIMER,
END_RESPONSE_TABLE;

//--------------------------------------------------------
// TGaugeWindow
// ~~~~~~~~~~
// Construction/Destruction handling.
//
TGaugeWindow::TGaugeWindow()
:
  TWindow(0, 0, 0)
{
  Attr.X = 50;
  Attr.Y = 50;
  Attr.W = 400;
  Attr.H = 400;
  Attr.Style |= WS_CLIPCHILDREN;
  Attr.ExStyle |= WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW;


  gaugeh1 = new TGauge(this, "", IDC_GAUGEH1, 48, 208, 288, 32, true);
  gaugeh1->SetNativeUse(nuAlways);

  gaugeh2 = new TGauge(this, "Gauge value: %d", IDC_GAUGEH2, 48, 264, 288, 32, true, 3);
  gaugeh2->SetNativeUse(nuNever);
  gaugeh2->SetColor(TColor::LtRed);

  gaugeh3 = new TGauge(this, "", IDC_GAUGEH3, 48, 320, 288, 32, true, 10);
  gaugeh3->SetNativeUse(nuNever);
  gaugeh3->SetLed(15, 80);
  gaugeh3->SetColor(TColor::LtGreen);

  gaugev1 = new TGauge(this, "", IDC_GAUGEV1, 48, 24, 40, 160, false, 10);
  gaugev1->SetNativeUse(nuNever);
  gaugev1->SetLed(10, 90);
  gaugev1->SetColor(TColor::LtYellow);

  gaugev2 = new TGauge(this, "%d", IDC_GAUGEV2, 176, 24, 40, 160, false, 5);
  gaugev2->SetNativeUse(nuNever);
  gaugev2->SetColor(*new TColor(253, 134, 2));

  gaugev3 = new TGauge(this, "", IDC_GAUGEV3, 296, 24, 40, 160, false);
  gaugev3->SetNativeUse(nuNever);
  gaugev3->SetColor(TColor::LtBlue);

  SetBkgndColor(TColor::Sys3dFace);
}

void TGaugeWindow::SetupWindow()
{
  TWindow::SetupWindow();

  SetTimer(IDT_GAUGEH1, 100);
  SetTimer(IDT_GAUGEH2, 200);
  SetTimer(IDT_GAUGEH3, 300);
  SetTimer(IDT_GAUGEV1, 400);
  SetTimer(IDT_GAUGEV2, 500);
  SetTimer(IDT_GAUGEV3, 600);
}


TGaugeWindow::~TGaugeWindow()
{
  delete gaugeh1;
  delete gaugeh2;
  delete gaugeh3;
  delete gaugev1;
  delete gaugev2;
  delete gaugev3;

  KillTimer(IDT_GAUGEH1);
  KillTimer(IDT_GAUGEH2);
  KillTimer(IDT_GAUGEH3);
  KillTimer(IDT_GAUGEV1);
  KillTimer(IDT_GAUGEV2);
  KillTimer(IDT_GAUGEV3);
}

void TGaugeWindow::EvTimer(uint timerId)
{
	switch (timerId)
   {
   	case IDT_GAUGEH1:
      	gaugeh1->StepIt();
         break;

      case IDT_GAUGEH2:
      	gaugeh2->StepIt();
         break;

      case IDT_GAUGEH3:
      	gaugeh3->StepIt();
         break;

      case IDT_GAUGEV1:
      	gaugev1->StepIt();
         break;

      case IDT_GAUGEV2:
      	gaugev2->StepIt();
         break;

      case IDT_GAUGEV3:
      	gaugev3->StepIt();
         break;
   }
}

int OwlMain(int , char* [])
{
  TGaugeApp   app;
  return app.Run();
}