//----------------------------------------------------------------------------
//  Project Combined
//  University of Mannheim
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    Combined Application
//  FILE:         cmbndabd.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TCombinedAboutDlg (TDialog).
//
//----------------------------------------------------------------------------
#if !defined(cmbndabd_h)              // Sentry, use file only if it's not already included.
#define cmbndabd_h

#include <owl/static.h>

#include "cmbndapp.rh"                  // Definition of all resources.


//{{TDialog = TCombinedAboutDlg}}
class TCombinedAboutDlg : public TDialog {
  public:
    TCombinedAboutDlg(TWindow* parent, TResId resId = IDD_ABOUT, TModule* module = 0);
    virtual ~TCombinedAboutDlg();

//{{TCombinedAboutDlgVIRTUAL_BEGIN}}
  public:
    void SetupWindow();
//{{TCombinedAboutDlgVIRTUAL_END}}

};    //{{TCombinedAboutDlg}}


// Reading the VERSIONINFO resource.
//
class TProjectRCVersion {
  public:
    TProjectRCVersion(TModule* module);
    virtual ~TProjectRCVersion();

    bool GetProductName(LPSTR& prodName);
    bool GetProductVersion(LPSTR& prodVersion);
    bool GetCopyright(LPSTR& copyright);
    bool GetDebug(LPSTR& debug);

  protected:
    uint8 far*  TransBlock;
    void far*   FVData;

  private:
    // Don't allow this object to be copied.
    //
    TProjectRCVersion(const TProjectRCVersion&);
    TProjectRCVersion& operator = (const TProjectRCVersion&);
};


#endif  // cmbndabd_h sentry.
