//----------------------------------------------------------------------------
//  Project Combined
//  University of Mannheim
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    Combined Application
//  FILE:         cmbndapp.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TCombinedApp (TApplication).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include <stdio.h>

#include "cmbndapp.h"
#include "cmbndwnd.h"                        // Definition of client class.
#include "cmbndabd.h"                        // Definition of about dialog.


//{{TCombinedApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TCombinedApp, TApplication)
//{{TCombinedAppRSP_TBL_BEGIN}}
  EV_COMMAND(CM_FILENEW, CmFileNew),
  EV_COMMAND(CM_FILEOPEN, CmFileOpen),
  EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{TCombinedAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//--------------------------------------------------------
// TCombinedApp
//
TCombinedApp::TCombinedApp() : TApplication("Combined")
{

  // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
  // computed in the member functions CmFileOpen, and CmFileSaveAs.
  //
  FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  FileData.SetFilter("Alle Dateien (*.*)|*.*|All Files (*.*)|*.*|");
  FileData.DefExt = "txt";

  // INSERT>> Your constructor code here.
}


TCombinedApp::~TCombinedApp()
{
  // INSERT>> Your destructor code here.
}


//--------------------------------------------------------
// TCombinedApp
// ~~~~~
// Application intialization.
//
void TCombinedApp::InitMainWindow()
{
  if (nCmdShow != SW_HIDE)
    nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

  TSDIDecFrame* frame = new TSDIDecFrame(0, GetName(), 0, false);

  // Assign icons for this application.
  //
  frame->SetIcon(this, IDI_SDIAPPLICATION);
  frame->SetIconSm(this, IDI_SDIAPPLICATION);

  // Menu associated with window and accelerator table associated with table.
  //
  frame->AssignMenu(IDM_SDI);

  // Associate with the accelerator table.
  //
  frame->Attr.AccelTable = IDM_SDI;

  SetMainWindow(frame);

  frame->SetMenuDescr(TMenuDescr(IDM_SDI));
}



//--------------------------------------------------------
// TCombinedApp
// ~~~~~~~~~~~
// Menu File New command
//
void TCombinedApp::CmFileNew()
{
}


//--------------------------------------------------------
// TCombinedApp
// ~~~~~~~~~~~
// Menu File Open command
//
void TCombinedApp::CmFileOpen()
{
  // Display standard Open dialog box to select a file name.
  //
  *FileData.FileName = 0;

  TCombinedWindow* client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), TCombinedWindow);     // Client window for the frame.
  if (client->CanClose())
    if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
      OpenFile();
}


void TCombinedApp::OpenFile(const char* fileName)
{
  if (fileName)
    strcpy(FileData.FileName, fileName);

}


//{{TSDIDecFrame Implementation}}


TSDIDecFrame::TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection, TModule* module)
:
  TDecoratedFrame(parent, title, !clientWnd ? new TCombinedWindow(0, "") : clientWnd, trackMenuSelection, module)
{
  // INSERT>> Your constructor code here.

}


TSDIDecFrame::~TSDIDecFrame()
{
  // INSERT>> Your destructor code here.

}


//--------------------------------------------------------
// TCombinedApp
// ~~~~~~~~~~~
// Menu Help About Combined command
//
void TCombinedApp::CmHelpAbout()
{
  // Show the modal dialog.
  //
  TCombinedAboutDlg(MainWindow).Execute();
}



int OwlMain(int , char* [])
{
  TCombinedApp   app;
  return app.Run();
}
