//----------------------------------------------------------------------------
//  Project Combined
//  University of Mannheim
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    Combined Application
//  FILE:         cmbndapp.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TCombinedApp (TApplication).
//
//----------------------------------------------------------------------------
#if !defined(cmbndapp_h)              // Sentry, use file only if it's not already included.
#define cmbndapp_h

#include <owl/opensave.h>


#include "cmbndapp.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = TSDIDecFrame}}
class TSDIDecFrame : public TDecoratedFrame {
  public:
    TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection = false, TModule* module = 0);
    ~TSDIDecFrame();
};    //{{TSDIDecFrame}}


//{{TApplication = TCombinedApp}}
class TCombinedApp : public TApplication {
  private:


  public:
    TCombinedApp();
    virtual ~TCombinedApp();

    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
    void OpenFile(const char* fileName = 0);

//{{TCombinedAppVIRTUAL_BEGIN}}
  public:
    virtual void InitMainWindow();
//{{TCombinedAppVIRTUAL_END}}

//{{TCombinedAppRSP_TBL_BEGIN}}
  protected:
    void CmFileNew();
    void CmFileOpen();
    void CmHelpAbout();
//{{TCombinedAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TCombinedApp);
};    //{{TCombinedApp}}


#endif  // cmbndapp_h sentry.
