//----------------------------------------------------------------------------
//  Project SimpleCM
//  University of Mannheim, Germany
//  Copyright  1997 . .
//
//  SUBSYSTEM:    SimpleCM Application
//  FILE:         smplcmap.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TSimpleCMApp (TApplication).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include <stdio.h>

#include "smplcmap.h"
#include "smplcmwn.h"                        // Definition of client class.
#include "smplcmad.h"                        // Definition of about dialog.


//{{TSimpleCMApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TSimpleCMApp, TApplication)
//{{TSimpleCMAppRSP_TBL_BEGIN}}
  EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{TSimpleCMAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//--------------------------------------------------------
// TSimpleCMApp
//
TSimpleCMApp::TSimpleCMApp() : TApplication("SimpleCM")
{

  // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
  // computed in the member functions CmFileOpen, and CmFileSaveAs.
  //
  FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
  FileData.SetFilter("Alle Dateien (*.*)|*.*|All Files (*.*)|*.*|");
  FileData.DefExt = "txt";

  // INSERT>> Your constructor code here.
}


TSimpleCMApp::~TSimpleCMApp()
{
  // INSERT>> Your destructor code here.
}


//--------------------------------------------------------
// TSimpleCMApp
// ~~~~~
// Application intialization.
//
void TSimpleCMApp::InitMainWindow()
{
  if (nCmdShow != SW_HIDE)
    nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

  TSDIDecFrame* frame = new TSDIDecFrame(0, GetName(), 0, false);

  // Assign icons for this application.
  //
  frame->SetIcon(this, IDI_SDIAPPLICATION);
  frame->SetIconSm(this, IDI_SDIAPPLICATION);

  // Menu associated with window and accelerator table associated with table.
  //
  frame->AssignMenu(IDM_SDI);

  // Associate with the accelerator table.
  //
  frame->Attr.AccelTable = IDM_SDI;

  SetMainWindow(frame);

  frame->SetMenuDescr(TMenuDescr(IDM_SDI));
}



//--------------------------------------------------------
// TSimpleCMApp
// ~~~~~~~~~~~
// Menu File New command
//
void TSimpleCMApp::CmFileNew()
{
}


//--------------------------------------------------------
// TSimpleCMApp
// ~~~~~~~~~~~
// Menu File Open command
//
void TSimpleCMApp::CmFileOpen()
{
}


void TSimpleCMApp::OpenFile(const char* fileName)
{

}


//{{TSDIDecFrame Implementation}}


TSDIDecFrame::TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection, TModule* module)
:
  TDecoratedFrame(parent, title, !clientWnd ? new TSimpleCMWindow(0, "") : clientWnd, trackMenuSelection, module)
{
  // INSERT>> Your constructor code here.

}


TSDIDecFrame::~TSDIDecFrame()
{
  // INSERT>> Your destructor code here.

}


//--------------------------------------------------------
// TSimpleCMApp
// ~~~~~~~~~~~
// Menu Help About SimpleCM command
//
void TSimpleCMApp::CmHelpAbout()
{
  // Show the modal dialog.
  //
  TSimpleCMAboutDlg(MainWindow).Execute();
}



int OwlMain(int , char* [])
{
  TSimpleCMApp   app;
  return app.Run();
}
