//----------------------------------------------------------------------------
//  Project SimpleCM
//  University of Mannheim, Germany
//  Copyright  1997 . .
//
//  SUBSYSTEM:    SimpleCM Application
//  FILE:         smplcmap.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TSimpleCMApp (TApplication).
//
//----------------------------------------------------------------------------
#if !defined(smplcmap_h)              // Sentry, use file only if it's not already included.
#define smplcmap_h

#include <owl/opensave.h>


#include "smplcmap.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = TSDIDecFrame}}
class TSDIDecFrame : public TDecoratedFrame {
  public:
    TSDIDecFrame(TWindow* parent, const char far* title, TWindow* clientWnd, bool trackMenuSelection = false, TModule* module = 0);
    ~TSDIDecFrame();
};    //{{TSDIDecFrame}}


//{{TApplication = TSimpleCMApp}}
class TSimpleCMApp : public TApplication {
  private:


  public:
    TSimpleCMApp();
    virtual ~TSimpleCMApp();

    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.
    void OpenFile(const char* fileName = 0);

//{{TSimpleCMAppVIRTUAL_BEGIN}}
  public:
    virtual void InitMainWindow();
//{{TSimpleCMAppVIRTUAL_END}}

//{{TSimpleCMAppRSP_TBL_BEGIN}}
  protected:
    void CmFileNew();
    void CmFileOpen();
    void CmHelpAbout();
//{{TSimpleCMAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TSimpleCMApp);
};    //{{TSimpleCMApp}}


#endif  // smplcmap_h sentry.
